/*
 * Decompiled with CFR 0.152.
 */
package ru.berdinskiybear.armorhud;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_4061;
import net.minecraft.class_768;
import net.uku3lig.ukulib.config.ConfigManager;
import net.uku3lig.ukulib.utils.Ukutils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.berdinskiybear.armorhud.compat.BedrockifyCompat;
import ru.berdinskiybear.armorhud.config.ArmorHudConfig;
import ru.berdinskiybear.armorhud.mixin.InventoryMenuAccessor;

public final class ArmorHudMod
implements ModInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArmorHudMod.class);
    public static final String MOD_ID = "ukus-armor-hud";
    private static final ConfigManager<ArmorHudConfig> manager = ConfigManager.createDefault(ArmorHudConfig.class, (String)"ukus-armor-hud");
    public static final int STEP = 20;
    public static final int SIZE = 22;
    public static final int HOTBAR_OFFSET = 98;
    public static final int OFFHAND_OFFSET = 29;
    public static final int ATTACK_INDICATOR_OFFSET = 23;
    public static final int WARNING_SIZE = 8;
    public static final class_3414 ARMOR_BREAKING_SOUND = class_3414.method_47908((class_2960)class_2960.method_60655((String)"ukus-armor-hud", (String)"armor_breaking"));
    public static final class_1304[] SLOT_IDS = InventoryMenuAccessor.getSLOT_IDS();
    private static final List<class_1799> lastStacks = new ArrayList<class_1799>(Collections.nCopies(SLOT_IDS.length, class_1799.field_8037));
    private static BedrockifyCompat bedrockifyCompat = null;

    @Nullable
    public static class_1657 getCameraPlayer() {
        class_1657 player;
        class_1297 class_12972 = class_310.method_1551().method_1560();
        return class_12972 instanceof class_1657 ? (player = (class_1657)class_12972) : null;
    }

    public static Optional<class_768> getWidgetRect(class_332 graphics, class_1657 player) {
        int sideOffsetMultiplier;
        int sideMultiplier;
        ArmorHudConfig config = (ArmorHudConfig)manager.getConfig();
        List<class_1799> armorItems = ArmorHudMod.getArmorItems(player);
        if (armorItems.isEmpty()) {
            return Optional.empty();
        }
        if (config.getAnchor() == ArmorHudConfig.Anchor.HOTBAR && config.getSide() == ArmorHudConfig.Side.LEFT || config.getAnchor() != ArmorHudConfig.Anchor.HOTBAR && config.getSide() == ArmorHudConfig.Side.RIGHT) {
            sideMultiplier = -1;
            sideOffsetMultiplier = -1;
        } else {
            sideMultiplier = 1;
            sideOffsetMultiplier = 0;
        }
        int addedHotbarOffset = switch (config.getOffhandSlotBehavior()) {
            default -> throw new MatchException(null, null);
            case ArmorHudConfig.OffhandSlotBehavior.ALWAYS_IGNORE -> 0;
            case ArmorHudConfig.OffhandSlotBehavior.ALWAYS_LEAVE_SPACE -> {
                if (player.method_6068() == config.getSide().asArm()) {
                    yield 23;
                }
                yield 29;
            }
            case ArmorHudConfig.OffhandSlotBehavior.ADHERE -> {
                if (player.method_6068() == config.getSide().asArm()) {
                    if (class_310.method_1551().field_1690.method_42565().method_41753() == class_4061.field_18153 && player.method_7261(0.0f) < 1.0f) {
                        yield 23;
                    }
                } else if (!player.method_6079().method_7960()) {
                    yield 29;
                }
                yield 0;
            }
        };
        int textureWidth = 22 + (armorItems.size() - 1) * 20;
        int widgetWidth = config.getOrientation() == ArmorHudConfig.Orientation.VERTICAL ? 22 : textureWidth;
        int widgetHeight = config.getOrientation() == ArmorHudConfig.Orientation.VERTICAL ? textureWidth : 22;
        int n = config.getOffsetX() * sideMultiplier;
        int armorWidgetX = n + (switch (config.getAnchor()) {
            default -> throw new MatchException(null, null);
            case ArmorHudConfig.Anchor.TOP_CENTER -> (graphics.method_51421() - widgetWidth) / 2;
            case ArmorHudConfig.Anchor.TOP, ArmorHudConfig.Anchor.BOTTOM -> (widgetWidth - graphics.method_51421()) * sideOffsetMultiplier;
            case ArmorHudConfig.Anchor.HOTBAR -> graphics.method_51421() / 2 + (98 + addedHotbarOffset) * sideMultiplier + widgetWidth * sideOffsetMultiplier;
        });
        int armorWidgetY = switch (config.getAnchor()) {
            default -> throw new MatchException(null, null);
            case ArmorHudConfig.Anchor.BOTTOM, ArmorHudConfig.Anchor.HOTBAR -> {
                int bedrockifyOffset = bedrockifyCompat != null ? bedrockifyCompat.screenSafeArea() : 0;
                yield graphics.method_51443() - widgetHeight - config.getOffsetY() - bedrockifyOffset;
            }
            case ArmorHudConfig.Anchor.TOP_CENTER, ArmorHudConfig.Anchor.TOP -> config.getOffsetY();
        };
        return Optional.of(new class_768(armorWidgetX, armorWidgetY, widgetWidth, widgetHeight));
    }

    public static Optional<class_768> getEffectiveWidgetRect(class_332 graphics, class_1657 player) {
        ArmorHudConfig config = (ArmorHudConfig)manager.getConfig();
        return ArmorHudMod.getWidgetRect(graphics, player).map(rect -> {
            if (config.getOrientation() == ArmorHudConfig.Orientation.HORIZONTAL) {
                int additionalHeight = 0;
                if (config.isWarningShown()) {
                    additionalHeight += 10 + config.getWarningBobIntensity() / 2;
                }
                if (config.getDurabilityDisplay() != ArmorHudConfig.DurabilityDisplay.BAR) {
                    Objects.requireNonNull(class_310.method_1551().field_1772);
                    additionalHeight += 9;
                }
                rect.method_35783(rect.method_3320() + additionalHeight);
                if (!config.getAnchor().isTop()) {
                    rect.method_35781(rect.method_3322() - additionalHeight);
                }
            }
            return rect;
        });
    }

    public static List<class_1799> getArmorItems(class_1657 player) {
        Stream<class_1799> items = Arrays.stream(SLOT_IDS).map(arg_0 -> ((class_1657)player).method_6118(arg_0));
        items = switch (((ArmorHudConfig)manager.getConfig()).getWidgetShown()) {
            default -> throw new MatchException(null, null);
            case ArmorHudConfig.WidgetShown.ALWAYS -> items;
            case ArmorHudConfig.WidgetShown.IF_ANY_PRESENT -> {
                List<class_1799> itemList = items.toList();
                if (itemList.stream().allMatch(class_1799::method_7960)) {
                    yield Stream.of(new class_1799[0]);
                }
                yield itemList.stream();
            }
            case ArmorHudConfig.WidgetShown.NOT_EMPTY -> items.filter(s -> !s.method_7960());
            case ArmorHudConfig.WidgetShown.DAMAGED_PIECES -> items.filter(ArmorHudMod::shouldShowWarning);
        };
        return items.toList();
    }

    public static boolean shouldPlayBreakSound(class_1657 player) {
        for (int i = 0; i < SLOT_IDS.length; ++i) {
            class_1304 slot = SLOT_IDS[i];
            class_1799 current = player.method_6118(slot);
            class_1799 last = lastStacks.set(i, current);
            if (last.method_7919() == current.method_7919() || !ArmorHudMod.shouldShowWarning(current)) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldShowWarning(class_1799 stack) {
        int maxDamage;
        if (stack.method_7960() || !stack.method_7963()) {
            return false;
        }
        int damage = stack.method_7919();
        double percentage = 1.0 - (double)damage / (double)(maxDamage = stack.method_7936());
        return percentage <= ((ArmorHudConfig)manager.getConfig()).getMinDurabilityPercentage() || maxDamage - damage <= ((ArmorHudConfig)manager.getConfig()).getMinDurabilityValue();
    }

    public void onInitialize() {
        Ukutils.registerToggleBind((class_304)new class_304("armorhud.keybind.toggle", -1, class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)MOD_ID, (String)"key"))), () -> ((ArmorHudConfig)manager.getConfig()).isEnabled(), b -> ((ArmorHudConfig)manager.getConfig()).setEnabled(b), (class_2561)class_2561.method_43471((String)"armorhud.keybind.toggle.msg"));
    }

    @Generated
    public static ConfigManager<ArmorHudConfig> getManager() {
        return manager;
    }

    @Generated
    public static BedrockifyCompat getBedrockifyCompat() {
        return bedrockifyCompat;
    }

    static {
        try {
            Class.forName("me.juancarloscp52.bedrockify.client.BedrockifyClient");
            bedrockifyCompat = new BedrockifyCompat();
        }
        catch (Exception e) {
            log.debug("Not enabling Bedrockify compatibility");
        }
    }
}

