/*
 * Decompiled with CFR 0.152.
 */
package ru.berdinskiybear.armorhud.mixin;

import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedCollection;
import net.minecraft.class_10209;
import net.minecraft.class_10799;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_5819;
import net.minecraft.class_768;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ru.berdinskiybear.armorhud.ArmorHudMod;
import ru.berdinskiybear.armorhud.config.ArmorHudConfig;
import ru.berdinskiybear.armorhud.mixin.InventoryMenuAccessor;

@Mixin(value={class_329.class})
public abstract class MixinGui {
    @Shadow
    @Final
    private class_5819 field_2034;
    @Unique
    private static final class_2960 WARNING_TEXTURE = class_2960.method_60655((String)"ukus-armor-hud", (String)"warn.png");
    @Shadow
    @Final
    private static class_2960 field_45310;
    @Shadow
    @Final
    private static class_2960 field_45312;

    @Shadow
    protected abstract void method_1762(class_332 var1, int var2, int var3, class_9779 var4, class_1657 var5, class_1799 var6, int var7);

    @Shadow
    public abstract class_327 method_1756();

    @Inject(method={"method_1759"}, at={@At(value="TAIL")})
    public void renderArmorHud(class_332 graphics, class_9779 tickCounter, CallbackInfo ci) {
        class_10209.method_64146().method_15396("ukus-armor-hud");
        this.drawArmorHud(graphics, tickCounter);
        class_10209.method_64146().method_15407();
    }

    @Unique
    private void drawArmorHud(class_332 graphics, class_9779 tickCounter) {
        ArmorHudConfig config = (ArmorHudConfig)ArmorHudMod.getManager().getConfig();
        if (!config.isEnabled()) {
            return;
        }
        class_1657 player = ArmorHudMod.getCameraPlayer();
        if (player == null) {
            return;
        }
        Optional<class_768> rect = ArmorHudMod.getWidgetRect(graphics, player);
        if (rect.isEmpty()) {
            return;
        }
        SequencedCollection<Object> armorItems = ArmorHudMod.getArmorItems(player);
        if (config.isReversed()) {
            armorItems = armorItems.reversed();
        }
        int textureWidth = 22 + (armorItems.size() - 1) * 20;
        graphics.method_51448().pushMatrix();
        graphics.method_51448().translate((float)rect.get().method_3321(), (float)rect.get().method_3322());
        if (config.getOrientation() == ArmorHudConfig.Orientation.VERTICAL) {
            graphics.method_51448().rotate(1.5707964f).translate(0.0f, -22.0f);
        }
        int color = ArmorHudMod.getBedrockifyCompat() != null ? class_9848.method_61317((float)ArmorHudMod.getBedrockifyCompat().hudOpacity()) : -1;
        switch (config.getStyle()) {
            case HOTBAR: {
                graphics.method_52708(class_10799.field_56883, field_45310, 182, 22, 0, 0, 0, 0, textureWidth - 3, 22, color);
                graphics.method_52708(class_10799.field_56883, field_45310, 182, 22, 179, 0, textureWidth - 3, 0, 3, 22, color);
                break;
            }
            case ROUNDED_CORNERS: {
                if (armorItems.size() > 1) {
                    graphics.method_52708(class_10799.field_56883, field_45312, 29, 24, 0, 1, 0, 0, 3, 22, color);
                    graphics.method_52708(class_10799.field_56883, field_45310, 182, 22, 3, 0, 3, 0, textureWidth - 6, 22, color);
                    graphics.method_52708(class_10799.field_56883, field_45312, 29, 24, 19, 1, textureWidth - 3, 0, 3, 22, color);
                    break;
                }
                graphics.method_52708(class_10799.field_56883, field_45312, 29, 24, 0, 1, 0, 0, 22, 22, color);
                break;
            }
            case ROUNDED: {
                if (armorItems.size() > 1) {
                    int borderWidth = 1;
                    graphics.method_52708(class_10799.field_56883, field_45312, 29, 24, 0, 1, 0, 0, 22 - borderWidth, 22, color);
                    for (int i = 1; i < armorItems.size() - 1; ++i) {
                        graphics.method_52708(class_10799.field_56883, field_45312, 29, 24, borderWidth, 1, borderWidth + i * 20, 0, 20, 22, color);
                    }
                    graphics.method_52708(class_10799.field_56883, field_45312, 29, 24, 1, 1, textureWidth - 20 - borderWidth, 0, 22 - borderWidth, 22, color);
                    break;
                }
                graphics.method_52708(class_10799.field_56883, field_45312, 29, 24, 0, 1, 0, 0, 22, 22, color);
            }
        }
        graphics.method_51448().popMatrix();
        for (int i = 0; i < armorItems.size(); ++i) {
            ArmorHudConfig.Side extrasSide;
            class_1799 stack = (class_1799)armorItems.get(i);
            int x = rect.get().method_3321();
            int y = rect.get().method_3322();
            switch (config.getOrientation()) {
                case HORIZONTAL: {
                    x += 20 * i;
                    break;
                }
                case VERTICAL: {
                    y += 20 * i;
                }
            }
            if (config.isIconsShown() && config.getWidgetShown().shouldDrawEmptySlots() && stack.method_7960()) {
                int slotIndex = config.isReversed() ? 3 - i : i;
                class_2960 identifier = InventoryMenuAccessor.getTEXTURE_EMPTY_SLOTS().get(ArmorHudMod.SLOT_IDS[slotIndex]);
                graphics.method_52706(class_10799.field_56883, identifier, x + 3, y + 3, 16, 16);
            }
            this.method_1762(graphics, x + 3, y + 3, tickCounter, player, stack, i + 1);
            ArmorHudConfig.Side side = extrasSide = config.getAnchor() == ArmorHudConfig.Anchor.HOTBAR ? config.getSide() : config.getSide().getOpposite();
            if (config.getAnchor().isTop() && config.getOrientation() == ArmorHudConfig.Orientation.HORIZONTAL) {
                y += 22;
            } else if (extrasSide == ArmorHudConfig.Side.RIGHT && config.getOrientation() == ArmorHudConfig.Orientation.VERTICAL) {
                x += 22;
            }
            if (config.getDurabilityDisplay() != ArmorHudConfig.DurabilityDisplay.BAR && !stack.method_7960()) {
                String dura = switch (config.getDurabilityDisplay()) {
                    default -> throw new MatchException(null, null);
                    case ArmorHudConfig.DurabilityDisplay.NUMERIC -> String.valueOf(stack.method_7936() - stack.method_7919());
                    case ArmorHudConfig.DurabilityDisplay.PERCENTAGE -> {
                        double percentage = 1.0 - (double)stack.method_7919() / (double)stack.method_7936();
                        yield (int)Math.floor(percentage * 100.0) + "%";
                    }
                    case ArmorHudConfig.DurabilityDisplay.BAR -> throw new IllegalStateException("unreachable");
                };
                Objects.requireNonNull(this.method_1756());
                int textHeight = 9;
                if (config.getOrientation() == ArmorHudConfig.Orientation.HORIZONTAL) {
                    if (!config.getAnchor().isTop()) {
                        y -= textHeight;
                    }
                    graphics.method_25300(this.method_1756(), dura, x + 11, y, class_9848.method_61334((int)stack.method_31580()));
                    if (config.getAnchor().isTop()) {
                        y += textHeight;
                    }
                } else {
                    int textWidth = this.method_1756().method_1727(dura) + 2;
                    int textY = (22 - textHeight) / 2;
                    if (extrasSide == ArmorHudConfig.Side.LEFT) {
                        x -= textWidth;
                    }
                    graphics.method_25303(this.method_1756(), dura, x + 1, y + textY, class_9848.method_61334((int)stack.method_31580()));
                    if (extrasSide == ArmorHudConfig.Side.RIGHT) {
                        x += textWidth;
                    }
                }
            }
            if (!config.isWarningShown() || !ArmorHudMod.shouldShowWarning(stack)) continue;
            if (config.getWarningBobIntensity() != 0) {
                int intensity = config.getWarningBobIntensity();
                y += (int)((double)this.field_2034.method_43048(intensity) - Math.ceil((float)intensity / 2.0f));
            }
            if (config.getOrientation() == ArmorHudConfig.Orientation.HORIZONTAL) {
                if (!config.getAnchor().isTop()) {
                    y -= 10;
                }
                int warnX = 7;
                graphics.method_25290(class_10799.field_56883, WARNING_TEXTURE, x + warnX, y + 1, 0.0f, 0.0f, 8, 8, 8, 8);
                continue;
            }
            if (extrasSide == ArmorHudConfig.Side.LEFT) {
                x -= 10;
            }
            int warnY = 7;
            graphics.method_25290(class_10799.field_56883, WARNING_TEXTURE, x + 1, y + warnY, 0.0f, 0.0f, 8, 8, 8, 8);
        }
    }

    @Inject(method={"method_1765"}, at={@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;")})
    public void calculateStatusEffectIconsOffset(class_332 graphics, class_9779 tickCounter, CallbackInfo ci, @Share(value="shift") LocalIntRef shiftRef) {
        ArmorHudConfig config = (ArmorHudConfig)ArmorHudMod.getManager().getConfig();
        if (!config.isEnabled() || !config.isPushStatusEffectIcons() || config.getAnchor() != ArmorHudConfig.Anchor.TOP || config.getSide() != ArmorHudConfig.Side.RIGHT) {
            return;
        }
        class_1657 player = ArmorHudMod.getCameraPlayer();
        if (player == null) {
            return;
        }
        Optional<class_768> rect = ArmorHudMod.getEffectiveWidgetRect(graphics, player);
        if (rect.isEmpty()) {
            return;
        }
        shiftRef.set(rect.get().method_3322() + rect.get().method_3320());
    }

    @ModifyVariable(method={"method_1765"}, at=@At(value="STORE"), ordinal=3)
    public int statusEffectIconsOffset(int y, @Share(value="shift") LocalIntRef shiftRef) {
        return y + shiftRef.get();
    }
}

