/*
 * Decompiled with CFR 0.152.
 */
package net.uku3lig.ukulib.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import lombok.Generated;
import net.uku3lig.ukulib.config.option.CyclingOption;
import net.uku3lig.ukulib.config.option.StringTranslatable;

public enum Position implements StringTranslatable
{
    TOP_LEFT("top_left", "ukulib.position.topLeft"),
    TOP_RIGHT("top_right", "ukulib.position.topRight"),
    BOTTOM_LEFT("bottom_left", "ukulib.position.bottomLeft"),
    BOTTOM_RIGHT("bottom_right", "ukulib.position.bottomRight"),
    MIDDLE("middle", "ukulib.position.middle");

    public static final String KEY = "ukulib.position";
    private final String name;
    private final String translationKey;

    public boolean isRight() {
        return Arrays.asList(TOP_RIGHT, BOTTOM_RIGHT).contains(this);
    }

    public boolean isBottom() {
        return Arrays.asList(BOTTOM_LEFT, BOTTOM_RIGHT).contains(this);
    }

    public static CyclingOption<Position> getOption(Position initialValue, Consumer<Position> setter) {
        return CyclingOption.ofTranslatableEnum(KEY, Position.class, initialValue, setter);
    }

    public static CyclingOption<Position> getOption(Collection<Position> allowedValues, Position initialValue, Consumer<Position> setter) {
        return CyclingOption.ofTranslatable(KEY, allowedValues, initialValue, setter);
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String getTranslationKey() {
        return this.translationKey;
    }

    @Generated
    private Position(String name, String translationKey) {
        this.name = name;
        this.translationKey = translationKey;
    }
}

