/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.options.table;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigTable;
import fi.dy.masa.malilib.config.options.ConfigBase;
import fi.dy.masa.malilib.config.options.table.Label;
import fi.dy.masa.malilib.config.options.table.TableRow;
import fi.dy.masa.malilib.config.options.table.type.BooleanEntry;
import fi.dy.masa.malilib.config.options.table.type.DoubleEntry;
import fi.dy.masa.malilib.config.options.table.type.Entry;
import fi.dy.masa.malilib.config.options.table.type.EntryTypes;
import fi.dy.masa.malilib.config.options.table.type.IntegerEntry;
import fi.dy.masa.malilib.config.options.table.type.LabelEntry;
import fi.dy.masa.malilib.config.options.table.type.StringEntry;
import java.lang.invoke.CallSite;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_5699;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@ApiStatus.Experimental
public class ConfigTable
extends ConfigBase<ConfigTable>
implements IConfigTable {
    public static final Codec<ConfigTable> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PrimitiveCodec.STRING.fieldOf("name").forGetter(ConfigBase::getName), (App)PrimitiveCodec.STRING.fieldOf("comment").forGetter(ConfigBase::getComment), (App)PrimitiveCodec.STRING.fieldOf("prettyName").forGetter(ConfigBase::getPrettyName), (App)PrimitiveCodec.STRING.fieldOf("translatedName").forGetter(ConfigBase::getTranslatedName), (App)PrimitiveCodec.STRING.fieldOf("displayString").forGetter(get -> get.displayString == null ? "n" : "s" + get.displayString), (App)class_5699.method_65313((Codec)PrimitiveCodec.STRING.listOf()).fieldOf("defaultTable").forGetter(get -> {
        ArrayList table = new ArrayList();
        for (TableRow row : get.getDefaultTable()) {
            ArrayList<CallSite> temp = new ArrayList<CallSite>();
            block8: for (Entry entry : row.list()) {
                Entry selector0$temp;
                Objects.requireNonNull(entry);
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StringEntry.class, LabelEntry.class, IntegerEntry.class, DoubleEntry.class, BooleanEntry.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        StringEntry str = (StringEntry)selector0$temp;
                        temp.add((CallSite)((Object)("str" + str.getValue())));
                        continue block8;
                    }
                    case 1: {
                        LabelEntry lbl = (LabelEntry)selector0$temp;
                        temp.add((CallSite)((Object)("lbl" + lbl.getValue().label())));
                        continue block8;
                    }
                    case 2: {
                        IntegerEntry integer = (IntegerEntry)selector0$temp;
                        temp.add((CallSite)((Object)("int" + integer.getValue())));
                        continue block8;
                    }
                    case 3: {
                        DoubleEntry dbl = (DoubleEntry)selector0$temp;
                        temp.add((CallSite)((Object)("dbl" + dbl.getValue())));
                        continue block8;
                    }
                    case 4: {
                        BooleanEntry bln = (BooleanEntry)selector0$temp;
                        temp.add((CallSite)((Object)("bln" + bln.getValue())));
                        continue block8;
                    }
                }
                throw new IllegalStateException("Unsupported type: " + String.valueOf((Object)entry.getType()));
            }
            table.add(temp);
        }
        return table;
    }), (App)class_5699.method_65313((Codec)PrimitiveCodec.STRING.listOf()).fieldOf("table").forGetter(get -> {
        ArrayList table = new ArrayList();
        for (TableRow row : get.getTable()) {
            ArrayList<CallSite> temp = new ArrayList<CallSite>();
            block8: for (Entry entry : row.list()) {
                Entry selector0$temp;
                Objects.requireNonNull(entry);
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StringEntry.class, LabelEntry.class, IntegerEntry.class, DoubleEntry.class, BooleanEntry.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        StringEntry str = (StringEntry)selector0$temp;
                        temp.add((CallSite)((Object)("str" + str.getValue())));
                        continue block8;
                    }
                    case 1: {
                        LabelEntry lbl = (LabelEntry)selector0$temp;
                        temp.add((CallSite)((Object)("lbl" + lbl.getValue().label())));
                        continue block8;
                    }
                    case 2: {
                        IntegerEntry integer = (IntegerEntry)selector0$temp;
                        temp.add((CallSite)((Object)("int" + integer.getValue())));
                        continue block8;
                    }
                    case 3: {
                        DoubleEntry dbl = (DoubleEntry)selector0$temp;
                        temp.add((CallSite)((Object)("dbl" + dbl.getValue())));
                        continue block8;
                    }
                    case 4: {
                        BooleanEntry bln = (BooleanEntry)selector0$temp;
                        temp.add((CallSite)((Object)("bln" + bln.getValue())));
                        continue block8;
                    }
                }
                throw new IllegalStateException("Unsupported type: " + String.valueOf((Object)entry.getType()));
            }
            table.add(temp);
        }
        return table;
    }), (App)class_5699.method_65313((Codec)PrimitiveCodec.STRING.listOf()).fieldOf("labels").forGetter(get -> {
        ArrayList<List<String>> labels = new ArrayList<List<String>>();
        for (Label label : get.getLabels()) {
            labels.add(List.of(label.label(), label.comment()));
        }
        return labels;
    }), (App)PrimitiveCodec.BOOL.fieldOf("showEntryNumbers").forGetter(ConfigTable::showEntryNumbers), (App)PrimitiveCodec.BOOL.fieldOf("allowNewEntry").forGetter(ConfigTable::allowNewEntry), (App)PrimitiveCodec.STRING.listOf().fieldOf("types").forGetter(get -> {
        ArrayList<String> typeNames = new ArrayList<String>();
        block7: for (EntryTypes type : get.types) {
            switch (type) {
                case STRING: {
                    typeNames.add("str");
                    continue block7;
                }
                case LABEL: {
                    typeNames.add("lbl");
                    continue block7;
                }
                case INTEGER: {
                    typeNames.add("int");
                    continue block7;
                }
                case DOUBLE: {
                    typeNames.add("dbl");
                    continue block7;
                }
                case BOOLEAN: {
                    typeNames.add("bln");
                    continue block7;
                }
            }
            throw new IllegalStateException("Unsupported type: " + type.name());
        }
        return typeNames;
    })).apply((Applicative)inst, ConfigTable::new));
    private final ImmutableList<@NotNull TableRow> defaultTable;
    private final List<TableRow> table = new ArrayList<TableRow>();
    @Nullable
    private final String displayString;
    private final ImmutableList<@NotNull EntryTypes> types;
    private final List<Label> labels;
    private final boolean allowNewEntry;
    private final boolean showEntryNumbers;

    private ConfigTable(String name, String comment, String prettyName, String translatedName, String displayString, List<List<String>> defaultValue, List<List<String>> value, List<List<String>> labels, Boolean showEntryNumbers, Boolean allowAddNewEntry, List<String> types) {
        this(name, comment, prettyName, translatedName, ConfigTable.strip(displayString), ConfigTable.parse(defaultValue), ConfigTable.parseLabels(labels), showEntryNumbers, (boolean)allowAddNewEntry, ConfigTable.parseTypes(types));
        this.table.addAll(ConfigTable.parse(value));
    }

    private static List<Label> parseLabels(List<List<String>> labels) {
        ArrayList<Label> labelList = new ArrayList<Label>();
        for (List<String> label : labels) {
            labelList.add(Label.of(label.getFirst(), label.get(1)));
        }
        return labelList;
    }

    private static List<TableRow> parse(List<List<String>> defaultValue) {
        ArrayList<TableRow> temp = new ArrayList<TableRow>();
        for (List<String> list : defaultValue) {
            TableRow entryList = new TableRow();
            block15: for (String entry : list) {
                String typeName = entry.substring(0, 3);
                String valueString = entry.substring(3);
                switch (typeName) {
                    case "str": {
                        entryList.add(StringEntry.of(valueString));
                        continue block15;
                    }
                    case "lbl": {
                        entryList.add(LabelEntry.of(valueString));
                        continue block15;
                    }
                    case "int": {
                        entryList.add(IntegerEntry.of(Integer.parseInt(valueString)));
                        continue block15;
                    }
                    case "dbl": {
                        entryList.add(DoubleEntry.of(Double.parseDouble(valueString)));
                        continue block15;
                    }
                    case "bln": {
                        entryList.add(BooleanEntry.of(Boolean.parseBoolean(valueString)));
                        continue block15;
                    }
                }
                throw new IllegalStateException("Unsupported type name: " + typeName);
            }
            temp.add(entryList);
        }
        return temp;
    }

    private static EntryTypes[] parseTypes(List<String> types) {
        ArrayList<EntryTypes> temp = new ArrayList<EntryTypes>();
        Iterator<String> iterator = types.iterator();
        block14: while (iterator.hasNext()) {
            String typeName;
            switch (typeName = iterator.next()) {
                case "str": {
                    temp.add(EntryTypes.STRING);
                    continue block14;
                }
                case "lbl": {
                    temp.add(EntryTypes.LABEL);
                    continue block14;
                }
                case "int": {
                    temp.add(EntryTypes.INTEGER);
                    continue block14;
                }
                case "dbl": {
                    temp.add(EntryTypes.DOUBLE);
                    continue block14;
                }
                case "bln": {
                    temp.add(EntryTypes.BOOLEAN);
                    continue block14;
                }
            }
            throw new IllegalStateException("Unsupported type name: " + typeName);
        }
        return temp.toArray(new EntryTypes[0]);
    }

    @Nullable
    private static String strip(String displayString) {
        if (displayString.equals("n")) {
            return null;
        }
        if (displayString.startsWith("s")) {
            return displayString.substring(1);
        }
        throw new IllegalStateException("Unsupported display string: " + displayString);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private ConfigTable(String name, String comment, String prettyName, String translatedName, @Nullable String displayString, List<TableRow> defaultValue, List<Label> labels, boolean showEntryNumbers, boolean allowAddNewEntry, EntryTypes ... types) {
        super(ConfigType.TABLE, name, comment, prettyName, translatedName);
        this.labels = labels;
        this.allowNewEntry = allowAddNewEntry;
        this.showEntryNumbers = showEntryNumbers;
        // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull ImmutableList.Builder ilb = ImmutableList.builder();
        for (EntryTypes type : types) {
            ilb.add((Object)type);
        }
        this.types = ilb.build();
        this.displayString = displayString;
        // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull ImmutableList.Builder ilb2 = ImmutableList.builder();
        for (TableRow list : defaultValue) {
            TableRow newEntry = new TableRow();
            newEntry.list().addAll(List.copyOf(list.list()));
            ilb2.add((Object)newEntry);
        }
        this.defaultTable = ilb2.build();
        this.table.addAll((Collection<TableRow>)this.defaultTable);
    }

    @Override
    public List<TableRow> getTable() {
        return this.table;
    }

    @Override
    public List<List<Object>> getRawTable() {
        ArrayList<List<Object>> rawTable = new ArrayList<List<Object>>();
        for (TableRow entry : this.table) {
            ArrayList<Entry> rawEntry = new ArrayList<Entry>(entry.list());
            rawTable.add(rawEntry);
        }
        return rawTable;
    }

    @Override
    public ImmutableList<@NotNull TableRow> getDefaultTable() {
        return this.defaultTable;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public ImmutableList<@NotNull List<Object>> getDefaultRawTable() {
        // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull ImmutableList.Builder ilb = new ImmutableList.Builder();
        for (TableRow entry : this.defaultTable) {
            ArrayList<Entry> rawEntry = new ArrayList<Entry>(entry.list());
            ilb.add(rawEntry);
        }
        return ilb.build();
    }

    @Override
    public void setTable(List<TableRow> newTable) {
        if (!this.table.equals(newTable)) {
            this.table.clear();
            this.table.addAll(newTable);
            this.onValueChanged();
        }
    }

    @Override
    public void setModified() {
        this.onValueChanged();
    }

    @Override
    @Nullable
    public String getDisplayString() {
        return this.displayString;
    }

    @Override
    public List<EntryTypes> getTypes() {
        return this.types;
    }

    @Override
    public void resetToDefault() {
        this.setTable((List<TableRow>)this.defaultTable);
    }

    @Override
    public boolean isModified() {
        for (int i = 0; i < this.table.size() && i < this.defaultTable.size(); ++i) {
            if (this.table.get(i).equals(this.defaultTable.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setValueFromJsonElement(JsonElement element) {
        ArrayList<TableRow> oldTable = new ArrayList<TableRow>();
        ArrayList<TableRow> tempTable = new ArrayList<TableRow>();
        for (TableRow entry : this.table) {
            oldTable.add(new TableRow(entry.list()));
        }
        try {
            JsonArray arr = element.getAsJsonArray();
            ArrayList<EntryTypes> inferredEntryTypes = new ArrayList<EntryTypes>();
            for (int row = 0; row < arr.size(); ++row) {
                JsonElement el = arr.get(row);
                if (!(el instanceof JsonArray)) {
                    throw new IllegalArgumentException("Data for " + this.getName() + " is corrupted; row is not a JSON array");
                }
                JsonArray jarr = (JsonArray)el;
                if (row != 0 && jarr.size() != inferredEntryTypes.size()) {
                    throw new IllegalArgumentException("Data for " + this.getName() + " is corrupted; row length mismatch");
                }
                ArrayList<Entry> tempList = new ArrayList<Entry>();
                block18: for (int col = 0; col < jarr.size(); ++col) {
                    JsonElement el2 = jarr.get(col);
                    if (!el2.isJsonObject()) {
                        throw new IllegalArgumentException("Data for " + this.getName() + " is corrupted; entry in row is not a json object");
                    }
                    JsonObject obj = el2.getAsJsonObject();
                    if (!obj.has("type")) {
                        throw new IllegalArgumentException("Data for " + this.getName() + " is corrupted; entry missing 'type'");
                    }
                    String type = obj.get("type").getAsString();
                    if (row == 0) {
                        inferredEntryTypes.add(EntryTypes.valueOf(type.toUpperCase(Locale.ROOT)));
                    } else {
                        EntryTypes expected = (EntryTypes)((Object)inferredEntryTypes.get(col));
                        if (!expected.name().equalsIgnoreCase(type)) {
                            throw new IllegalArgumentException("Data for " + this.getName() + " is corrupted; not all stored rows have the same types (mismatch at column " + col + ")");
                        }
                    }
                    switch (type) {
                        case "string": {
                            tempList.add(StringEntry.getFromJsonObject(obj));
                            continue block18;
                        }
                        case "integer": {
                            tempList.add(IntegerEntry.getFromJsonObject(obj));
                            continue block18;
                        }
                        case "double": {
                            tempList.add(DoubleEntry.getFromJsonObject(obj));
                            continue block18;
                        }
                        case "boolean": {
                            tempList.add(BooleanEntry.getFromJsonObject(obj));
                            continue block18;
                        }
                        case "label": {
                            tempList.add(LabelEntry.getFromJsonObject(obj));
                        }
                    }
                }
                tempTable.add(new TableRow(tempList));
            }
            if (!this.types.equals(inferredEntryTypes) && !inferredEntryTypes.isEmpty()) {
                throw new IllegalArgumentException("Data for " + this.getName() + " is corrupted; types in the config don't match the stored types, expected " + String.valueOf(this.types) + " but got " + String.valueOf(inferredEntryTypes));
            }
            this.table.clear();
            this.table.addAll(tempTable);
            if (!this.table.equals(oldTable)) {
                this.onValueChanged();
            }
        }
        catch (Exception e) {
            MaLiLib.LOGGER.error("Failed to set config value for '{}' from the JSON element '{}': {}", (Object)this.getName(), (Object)element, (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public JsonElement getAsJsonElement() {
        JsonArray tableArr = new JsonArray();
        for (TableRow row : this.table) {
            JsonArray entryArr = new JsonArray();
            for (Entry entry : row.list()) {
                entryArr.add((JsonElement)entry.getAsJsonObject());
            }
            tableArr.add((JsonElement)entryArr);
        }
        return tableArr;
    }

    @Override
    public List<Label> getLabels() {
        return this.labels;
    }

    @Override
    public boolean allowNewEntry() {
        return this.allowNewEntry;
    }

    @Override
    public boolean showEntryNumbers() {
        return this.showEntryNumbers;
    }

    @NotNull
    public static TableRow getDummy(List<EntryTypes> types) {
        TableRow dummy = new TableRow();
        for (EntryTypes type : types) {
            if (type == EntryTypes.STRING) {
                dummy.add(StringEntry.of(""));
                continue;
            }
            if (type == EntryTypes.LABEL) {
                dummy.add(LabelEntry.of(""));
                continue;
            }
            if (type == EntryTypes.INTEGER) {
                dummy.add(IntegerEntry.of(0));
                continue;
            }
            if (type == EntryTypes.DOUBLE) {
                dummy.add(DoubleEntry.of(0.0));
                continue;
            }
            if (type == EntryTypes.BOOLEAN) {
                dummy.add(BooleanEntry.of(false));
                continue;
            }
            throw new IllegalStateException("Unsupported type: " + type.name());
        }
        return dummy;
    }

    public static class Builder {
        private String name;
        private String comment = null;
        private String prettyName = null;
        private String translatedName = null;
        @Nullable
        private String displayString = null;
        private List<TableRow> defaultValue = null;
        private List<Label> labels = List.of();
        private boolean showEntryNumbers = true;
        private boolean allowAddNewEntry = true;
        private EntryTypes[] types;
        private int entryCount = -1;

        public Builder(String name, EntryTypes ... types) {
            if (types.length == 0) {
                throw new IllegalStateException("There must be at least one type.");
            }
            this.name = name;
            this.types = types;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder setPrettyName(String prettyName) {
            this.prettyName = prettyName;
            return this;
        }

        public Builder setTranslatedName(String translatedName) {
            this.translatedName = translatedName;
            return this;
        }

        public Builder setDisplayString(@Nullable String displayString) {
            this.displayString = displayString;
            return this;
        }

        public Builder setDefaultValue(TableRow ... defaultValue) {
            this.defaultValue = List.of(defaultValue);
            return this;
        }

        public Builder setLabels(List<Object> labels) {
            return this.setLabels(labels.toArray(new Object[0]));
        }

        public Builder setLabels(Object ... labels) {
            this.labels = new ArrayList<Label>();
            for (Object o : labels) {
                if (o instanceof String) {
                    String str = (String)o;
                    this.labels.add(Label.of(str, ""));
                    continue;
                }
                if (o instanceof Label) {
                    Label label = (Label)o;
                    this.labels.add(label);
                    continue;
                }
                throw new IllegalArgumentException("labels contains an instance of type " + o.getClass().getSimpleName() + " which is not String or Label");
            }
            return this;
        }

        public Builder setShowEntryNumbers(boolean showEntryNumbers) {
            this.showEntryNumbers = showEntryNumbers;
            return this;
        }

        public Builder setAllowAddNewEntry(boolean allowAddNewEntry) {
            this.allowAddNewEntry = allowAddNewEntry;
            return this;
        }

        public Builder setTypes(EntryTypes ... types) {
            if (types.length == 0) {
                throw new IllegalStateException("There must be at least one type.");
            }
            this.types = types;
            return this;
        }

        public Builder setEntryCount(@Range(from=1L, to=0x7FFFFFFFL) int count) {
            this.entryCount = count;
            return this;
        }

        public ConfigTable build() {
            return this.build(false);
        }

        public ConfigTable build(boolean ignoreWarning) {
            if (this.defaultValue != null && this.defaultValue.size() != this.entryCount && this.entryCount > 0 && this.defaultValue.size() > 1) {
                throw new IllegalArgumentException("Default value (" + this.defaultValue.size() + ") must have the same count as entryCount (" + this.entryCount + ")");
            }
            this.defaultValue = this.defaultValue == null ? new ArrayList<TableRow>() : new ArrayList<TableRow>(this.defaultValue);
            if (this.defaultValue.size() == 1 && this.entryCount > 0) {
                for (i = 0; i < this.entryCount; ++i) {
                    this.defaultValue.add(new TableRow(this.defaultValue.getFirst().list()));
                }
            } else if (this.entryCount > 0 && this.defaultValue.isEmpty()) {
                for (i = 0; i < this.entryCount; ++i) {
                    this.defaultValue.add(ConfigTable.getDummy(List.of(this.types)));
                }
            }
            if (this.comment == null) {
                this.comment = this.name + " Comment?";
            }
            if (this.prettyName == null) {
                this.prettyName = this.name;
            }
            if (this.translatedName == null) {
                this.translatedName = this.name;
            }
            for (TableRow v : this.defaultValue) {
                for (int j = 0; j < this.types.length; ++j) {
                    if (v.list().get(j).getType() != this.types[j]) {
                        throw new IllegalArgumentException("Type mismatch: expected " + String.valueOf((Object)this.types[j]) + " but got " + v.list().get(j).getType().name());
                    }
                    if (!this.allowAddNewEntry || this.types[j] != EntryTypes.LABEL || !FabricLoader.getInstance().isDevelopmentEnvironment() || ignoreWarning) continue;
                    MaLiLib.LOGGER.warn("You probably shouldn't enable allowAddNewEntry if you are using labels.");
                }
            }
            return new ConfigTable(this.name, this.comment, this.prettyName, this.translatedName, this.displayString, this.defaultValue, this.labels, this.showEntryNumbers, this.allowAddNewEntry, this.types);
        }
    }
}

