/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.option;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import journeymap.client.Constants;
import journeymap.client.cartography.color.RGB;
import journeymap.client.properties.ClientCategory;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.DraggableListPane;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.ResetButton;
import journeymap.client.ui.component.screens.JmUILegacy;
import journeymap.client.ui.minimap.Effect;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.ui.minimap.Position;
import journeymap.client.ui.minimap.Selectable;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.OptionSlotFactory;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.common.properties.PropertiesBase;
import journeymap.common.properties.catagory.Category;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6880;

public class MinimapOptions
extends JmUILegacy {
    protected Button buttonClose;
    protected DraggableListPane<CategorySlot> minimapPositionPane;
    private final MiniMapProperties miniMapProperties;
    private final MiniMap minimap;
    private final Effect effect;
    private Selectable selected;
    boolean dragging = false;
    private Selectable notSelected;
    private Map<class_6880<class_1291>, class_1293> activeEffects;
    private Map<Category, PropertiesBase> slotMap = Maps.newHashMap();
    private static final Map<class_6880<class_1291>, class_1293> FAKE_EFFECT_MAP;

    public MinimapOptions(class_437 returnDisplay, MiniMapProperties miniMapProperties) {
        super(Constants.getString("jm.common.minimap_options.title"), returnDisplay);
        this.miniMapProperties = miniMapProperties;
        UIManager.INSTANCE.switchMiniMapPreset(miniMapProperties.getId());
        this.minimap = UIManager.INSTANCE.getMiniMap();
        UIManager.INSTANCE.getMiniMap().setDrawingInPreviewMode(true);
        this.effect = Effect.getInstance();
        this.slotMap.put(ClientCategory.MinimapPosition, miniMapProperties);
        this.activeEffects = Maps.newHashMap((Map)class_310.method_1551().field_1724.method_6088());
        class_310.method_1551().field_1724.method_6088().clear();
    }

    @Override
    public void method_25423(int width, int height) {
        super.setRenderBottomBar(true);
        super.method_25423(width, height);
        Objects.requireNonNull(this);
        this.drawOptionsPane(20, 36);
        this.buttonClose = this.method_37063(new Button(Constants.getString("jm.common.close"), button -> this.closeAndReturn()));
        this.buttonClose.fitWidth(this.field_22787.field_1772);
        this.buttonClose.method_46421(this.field_22787.method_22683().method_4486() / 2 - this.buttonClose.method_25368() / 2);
        this.buttonClose.method_46419(this.field_22787.method_22683().method_4502() - 25);
    }

    protected void drawOptionsPane(int x, int y) {
        Objects.requireNonNull(this);
        this.minimapPositionPane = new DraggableListPane(this.field_22787, 0, 36, x, y);
        List<CategorySlot> slotList = OptionSlotFactory.getOptionSlots(this.getToolbars(this.minimapPositionPane), this.slotMap, false, true);
        this.minimapPositionPane.setAlignTop(false);
        this.minimapPositionPane.setSlots(slotList);
        this.minimapPositionPane.updateSlots();
    }

    protected Map<Category, List<SlotMetadata>> getToolbars(ScrollListPane<CategorySlot> pane) {
        HashMap<Category, List<SlotMetadata>> toolbars = new HashMap<Category, List<SlotMetadata>>();
        for (Category category : ClientCategory.values) {
            String name = Constants.getString("jm.config.reset");
            String tooltip = Constants.getString("jm.config.reset.tooltip");
            SlotMetadata toolbarSlotMetadata = new SlotMetadata(new ResetButton(category, button -> this.refreshOptions(category, pane, true)), name, tooltip);
            toolbars.put(category, Arrays.asList(toolbarSlotMetadata));
        }
        return toolbars;
    }

    protected void refreshOptions(Category category, ScrollListPane<CategorySlot> pane, boolean reset) {
        HashSet<PropertiesBase> updatedProperties = new HashSet<PropertiesBase>();
        for (CategorySlot categorySlot : pane.getRootSlots()) {
            if (!category.equals(categorySlot.getCategory())) continue;
            for (SlotMetadata slotMetadata : categorySlot.getAllChildMetadata()) {
                if (reset) {
                    slotMetadata.resetToDefaultValue();
                }
                if (!slotMetadata.hasConfigField()) continue;
                PropertiesBase properties = slotMetadata.getProperties();
                if (reset) {
                    if (properties instanceof MiniMapProperties) {
                        this.miniMapProperties.effectTranslateX.setToDefault();
                        this.miniMapProperties.effectTranslateY.setToDefault();
                        this.miniMapProperties.positionX.set(Float.valueOf(0.82f));
                        this.miniMapProperties.positionY.set(Float.valueOf(0.05f));
                    }
                    this.miniMapProperties.effectTranslateX.set((Object)0);
                }
                if (properties != null) {
                    updatedProperties.add(properties);
                }
                slotMetadata.getButton().refresh();
            }
        }
        for (PropertiesBase properties : updatedProperties) {
            properties.save();
        }
        this.minimapPositionPane.updateSlots();
    }

    @Override
    public void method_25394(class_332 graphics, int x, int y, float partialTicks) {
        class_4587 pose = new class_4587();
        this.effect.renderBorder(graphics, this.effect == this.selected ? -16711936 : -65536);
        this.minimap.drawMap(graphics, true);
        this.minimap.renderBorder(graphics, this.minimap == this.selected ? -16711936 : -65536);
        if (!this.dragging) {
            super.method_25394(graphics, x, y, partialTicks);
        }
        if (this.minimapPositionPane != null) {
            List lastTooltip = this.minimapPositionPane.lastTooltip;
            long lastTooltipTime = this.minimapPositionPane.lastTooltipTime;
            this.minimapPositionPane.lastTooltip = null;
            if (!this.dragging) {
                this.minimapPositionPane.method_25394(graphics, x, y, partialTicks);
            }
            this.minimap.updateDisplayVars(true, true);
            this.renderTooltip(graphics, pose, x, lastTooltipTime, lastTooltip);
        }
        this.field_22787.field_1724.method_6088().putAll(FAKE_EFFECT_MAP);
    }

    @Override
    protected void drawTitle(class_332 graphics, class_4587 pose) {
        Objects.requireNonNull(this);
        int top = 36 >> 1;
        class_327 font = class_310.method_1551().field_1772;
        class_5250 title = class_2561.method_43471((String)"jm.common.minimap_options.title").method_27692(class_124.field_1073);
        class_5250 titleText = class_2561.method_43471((String)"jm.common.minimap_options.title_text");
        String apiVersion = "API v2.0.0-SNAPSHOT";
        pose.method_22903();
        pose.method_46416(0.0f, 0.0f, -100.0f);
        graphics.method_25294(0, 0, this.field_22789, 36, RGB.toArgb(0, 0.5f));
        graphics.method_27534(font, (class_2561)title, this.field_22789 / 2, top - 10, Color.CYAN.getRGB());
        graphics.method_27534(font, (class_2561)titleText, this.field_22789 / 2, top, Color.CYAN.getRGB());
        pose.method_22905(0.5f, 0.5f, 0.0f);
        graphics.method_25303(font, apiVersion, this.field_22789 * 2 - 10 - font.method_1727(apiVersion), top + 10, 0xCCCCCC);
        pose.method_22909();
    }

    protected void drawLogo(class_332 graphics) {
    }

    private void renderTooltip(class_332 graphics, class_4587 pose, int x, long lastTooltipTime, List<class_5481> lastTooltip) {
        if (this.minimapPositionPane.lastTooltip != null && !this.minimapPositionPane.lastTooltip.equals(lastTooltip)) {
            this.minimapPositionPane.lastTooltipTime = lastTooltipTime;
            if (System.currentTimeMillis() - this.minimapPositionPane.lastTooltipTime > this.minimapPositionPane.hoverDelay) {
                Button button = this.minimapPositionPane.lastTooltipMetadata.getButton();
                graphics.method_51447(this.field_22793, this.minimapPositionPane.lastTooltip, x, button.getBottomY() + 15);
            }
        }
    }

    @Override
    protected void closeAndReturn() {
        this.cleanup();
        super.closeAndReturn();
    }

    public void method_25419() {
        this.cleanup();
        super.method_25419();
    }

    private void cleanup() {
        UIManager.INSTANCE.getMiniMap().setDrawingInPreviewMode(false);
        this.removeTempEffects();
    }

    private void removeTempEffects() {
        this.field_22787.field_1724.method_6088().clear();
        this.field_22787.field_1724.method_6088().putAll(this.activeEffects);
    }

    @Override
    protected void layoutButtons(class_332 graphics, class_4587 pose) {
        if (this.getRenderables().isEmpty()) {
            this.method_25426();
        }
    }

    @Override
    public void method_25420(class_332 graphics, int i, int j, float f) {
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (this.minimapPositionPane.method_25402(event, doubleClick)) {
            this.minimap.updateDisplayVars(true, true);
        } else {
            if (this.minimap.mouseClicked(event, doubleClick)) {
                if (!Position.Custom.equals(this.miniMapProperties.position.get())) {
                    int oldX = this.minimapPositionPane.method_46426();
                    int oldY = this.minimapPositionPane.method_46427();
                    this.miniMapProperties.position.set(Position.Custom);
                    this.miniMapProperties.position.save();
                    this.drawOptionsPane(oldX, oldY);
                    ((CategorySlot)this.minimapPositionPane.getRootSlots().get(0)).setSelected(true);
                    this.minimapPositionPane.updateSlots();
                    this.minimapPositionPane.setClicked(true);
                }
                this.selected = this.minimap;
                this.notSelected = this.effect;
                return true;
            }
            if (this.effect.mouseClicked(event, doubleClick)) {
                this.selected = this.effect;
                this.notSelected = this.minimap;
                return true;
            }
        }
        return super.method_25402(event, doubleClick);
    }

    public boolean method_25401(double x, double y, double f, double scroll) {
        this.minimapPositionPane.method_25401(x, y, f, scroll);
        return super.method_25401(x, y, f, scroll);
    }

    public boolean method_25403(class_11909 event, double pDragX, double pDragY) {
        if (!this.minimapPositionPane.method_25403(event, pDragX, pDragY) && this.selected != null && this.selected.mouseDragged(event, pDragX, pDragY)) {
            this.dragging = true;
            return true;
        }
        return super.method_25403(event, pDragX, pDragY);
    }

    public boolean method_25406(class_11909 event) {
        this.dragging = false;
        this.minimapPositionPane.method_25406(event);
        this.minimap.mouseReleased(event);
        this.effect.mouseReleased(event);
        return super.method_25406(event);
    }

    public void method_25393() {
        if (this.selected != null) {
            this.selected.tick();
        }
    }

    static {
        ArrayList fakeEffect = Lists.newArrayList((Object[])new class_1293[]{new class_1293(class_1294.field_5908), new class_1293(class_1294.field_5919), new class_1293(class_1294.field_5899), new class_1293(class_1294.field_5924), new class_1293(class_1294.field_5907), new class_1293(class_1294.field_5923), new class_1293(class_1294.field_5905)});
        FAKE_EFFECT_MAP = fakeEffect.stream().collect(Collectors.toMap(class_1293::method_5579, e -> e));
    }
}

