/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.world;

import com.seibel.distanthorizons.api.interfaces.world.IDhApiDimensionTypeWrapper;
import com.seibel.distanthorizons.api.interfaces.world.IDhApiLevelWrapper;
import com.seibel.distanthorizons.api.interfaces.world.IDhApiWorldProxy;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftSharedWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.util.ArrayList;

public class DhApiWorldProxy
implements IDhApiWorldProxy {
    public static DhApiWorldProxy INSTANCE = new DhApiWorldProxy();
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final IMinecraftSharedWrapper MC_SHARED = SingletonInjector.INSTANCE.get(IMinecraftSharedWrapper.class);
    private static final String NO_WORLD_EXCEPTION_STRING = "No world loaded";
    private boolean isReadOnly = false;

    private DhApiWorldProxy() {
    }

    @Override
    public boolean worldLoaded() {
        return SharedApi.getAbstractDhWorld() != null;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws IllegalStateException {
        this.setReadOnly(readOnly, true);
    }

    public void setReadOnly(boolean readOnly, boolean throwIfWorldUnloaded) throws IllegalStateException {
        if (throwIfWorldUnloaded && SharedApi.getAbstractDhWorld() == null) {
            throw new IllegalStateException(NO_WORLD_EXCEPTION_STRING);
        }
        boolean valueChanged = this.isReadOnly != readOnly;
        this.isReadOnly = readOnly;
        if (valueChanged) {
            if (this.isReadOnly) {
                LOGGER.info("DH world set to read-only. LODs will not update while this API flag is active.", new Object[0]);
            } else {
                LOGGER.info("DH world is no longer in read-only mode. LODs will update like normal.", new Object[0]);
            }
        }
    }

    @Override
    public boolean getReadOnly() throws IllegalStateException {
        if (SharedApi.getAbstractDhWorld() == null) {
            throw new IllegalStateException(NO_WORLD_EXCEPTION_STRING);
        }
        return this.isReadOnly;
    }

    @Override
    public IDhApiLevelWrapper getSinglePlayerLevel() throws IllegalStateException {
        if (SharedApi.getAbstractDhWorld() == null) {
            throw new IllegalStateException(NO_WORLD_EXCEPTION_STRING);
        }
        if (MC_SHARED.isDedicatedServer()) {
            return null;
        }
        return MC_CLIENT.getWrappedClientLevel();
    }

    @Override
    public Iterable<IDhApiLevelWrapper> getAllLoadedLevelWrappers() throws IllegalStateException {
        AbstractDhWorld world = SharedApi.getAbstractDhWorld();
        if (world == null) {
            throw new IllegalStateException(NO_WORLD_EXCEPTION_STRING);
        }
        ArrayList<IDhApiLevelWrapper> returnList = new ArrayList<IDhApiLevelWrapper>();
        for (IDhLevel iDhLevel : world.getAllLoadedLevels()) {
            returnList.add(iDhLevel.getLevelWrapper());
        }
        return returnList;
    }

    @Override
    public Iterable<IDhApiLevelWrapper> getAllLoadedLevelsForDimensionType(IDhApiDimensionTypeWrapper dimensionTypeWrapper) throws IllegalStateException {
        AbstractDhWorld world = SharedApi.getAbstractDhWorld();
        if (world == null) {
            throw new IllegalStateException(NO_WORLD_EXCEPTION_STRING);
        }
        ArrayList<IDhApiLevelWrapper> returnList = new ArrayList<IDhApiLevelWrapper>();
        for (IDhLevel iDhLevel : world.getAllLoadedLevels()) {
            ILevelWrapper levelWrapper = iDhLevel.getLevelWrapper();
            if (!levelWrapper.getDimensionType().equals(dimensionTypeWrapper)) continue;
            returnList.add(levelWrapper);
        }
        return returnList;
    }

    @Override
    public Iterable<IDhApiLevelWrapper> getAllLoadedLevelsWithDimensionNameLike(String dimensionName) throws IllegalStateException {
        AbstractDhWorld world = SharedApi.getAbstractDhWorld();
        if (world == null) {
            throw new IllegalStateException(NO_WORLD_EXCEPTION_STRING);
        }
        String soughtDimName = dimensionName.toLowerCase();
        ArrayList<IDhApiLevelWrapper> returnList = new ArrayList<IDhApiLevelWrapper>();
        for (IDhLevel iDhLevel : world.getAllLoadedLevels()) {
            ILevelWrapper levelWrapper = iDhLevel.getLevelWrapper();
            String levelDimName = levelWrapper.getDhIdentifier().toLowerCase();
            if (!levelDimName.contains(soughtDimName)) continue;
            returnList.add(levelWrapper);
        }
        return returnList;
    }
}

