/*
 * Decompiled with CFR 0.152.
 */
package net.uku3lig.ukulib.config.option.widget;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.class_10799;
import net.minecraft.class_1144;
import net.minecraft.class_11876;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_8666;
import net.uku3lig.ukulib.config.option.CheckedOption;
import org.jetbrains.annotations.NotNull;

public class TextInputWidget
extends class_339
implements CheckedOption {
    private static final class_8666 TEXTURES = new class_8666(class_2960.method_60656((String)"widget/text_field"), class_2960.method_60656((String)"widget/text_field_highlighted"));
    private static final String HORIZONTAL_CURSOR = "_";
    private static final int TEXT_COLOR = -2039584;
    private static final int INVALID_COLOR = -65536;
    private final class_327 font;
    private String text = "";
    private final int maxLength;
    private final boolean drawsBackground = true;
    private int firstCharacterIndex;
    private int selectionStart;
    private int selectionEnd;
    private final String suggestion;
    private final Consumer<String> changedListener;
    private final Predicate<String> textPredicate;
    private long lastSwitchFocusTime = class_156.method_658();
    private int textX;
    private int textY;

    public TextInputWidget(int x, int y, int width, int height, String initialValue, Consumer<String> changedListener, String suggestion, Predicate<String> textPredicate, int maxLength) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)suggestion));
        this.font = class_310.method_1551().field_1772;
        this.changedListener = changedListener;
        this.suggestion = suggestion;
        this.textPredicate = textPredicate;
        this.maxLength = maxLength;
        this.setText(initialValue);
        this.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)this.suggestion)));
        this.updateTextPosition();
    }

    @NotNull
    protected class_5250 method_25360() {
        class_2561 text = this.method_25369();
        return class_2561.method_43469((String)"gui.narrate.editBox", (Object[])new Object[]{text, this.text});
    }

    public void setText(String text) {
        this.text = text.length() > this.maxLength ? text.substring(0, this.maxLength) : text;
        this.setCursorToEnd(false);
        this.setSelectionEnd(this.selectionStart);
        this.onChanged(text);
    }

    public String getSelectedText() {
        int i = Math.min(this.selectionStart, this.selectionEnd);
        int j = Math.max(this.selectionStart, this.selectionEnd);
        return this.text.substring(i, j);
    }

    public void method_46421(int x) {
        super.method_46421(x);
        this.updateTextPosition();
    }

    public void method_46419(int y) {
        super.method_46419(y);
        this.updateTextPosition();
    }

    public void write(String text) {
        int i = Math.min(this.selectionStart, this.selectionEnd);
        int j = Math.max(this.selectionStart, this.selectionEnd);
        int k = this.maxLength - this.text.length() - (i - j);
        if (k > 0) {
            String string = class_3544.method_57180((String)text);
            int l = string.length();
            if (k < l) {
                if (Character.isHighSurrogate(string.charAt(k - 1))) {
                    --k;
                }
                string = string.substring(0, k);
                l = k;
            }
            this.text = new StringBuilder(this.text).replace(i, j, string).toString();
            this.setSelectionStart(i + l);
            this.setSelectionEnd(this.selectionStart);
            this.onChanged(this.text);
        }
    }

    private void onChanged(String newText) {
        if (this.changedListener != null && this.textPredicate.test(newText)) {
            this.changedListener.accept(newText);
        }
        this.updateTextPosition();
    }

    private void erase(int offset, boolean bl) {
        if (bl) {
            this.eraseWords(offset);
        } else {
            this.eraseCharacters(offset);
        }
    }

    public void eraseWords(int wordOffset) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.selectionStart) {
                this.write("");
            } else {
                this.eraseCharactersTo(this.getWordSkipPosition(wordOffset));
            }
        }
    }

    public void eraseCharacters(int characterOffset) {
        this.eraseCharactersTo(this.getCursorPosWithOffset(characterOffset));
    }

    public void eraseCharactersTo(int position) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.selectionStart) {
                this.write("");
            } else {
                int j;
                int i = Math.min(position, this.selectionStart);
                if (i != (j = Math.max(position, this.selectionStart))) {
                    this.text = new StringBuilder(this.text).delete(i, j).toString();
                    this.setCursor(i, false);
                }
            }
        }
    }

    public int getWordSkipPosition(int wordOffset) {
        return this.getWordSkipPosition(wordOffset, this.getCursor());
    }

    private int getWordSkipPosition(int wordOffset, int cursorPosition) {
        int i = cursorPosition;
        boolean bl = wordOffset < 0;
        int j = Math.abs(wordOffset);
        for (int k = 0; k < j; ++k) {
            if (!bl) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursor(int offset, boolean shiftKeyPressed) {
        this.setCursor(this.getCursorPosWithOffset(offset), shiftKeyPressed);
    }

    private int getCursorPosWithOffset(int offset) {
        return class_156.method_27761((String)this.text, (int)this.selectionStart, (int)offset);
    }

    public void setCursor(int cursor, boolean select) {
        this.setSelectionStart(cursor);
        if (!select) {
            this.setSelectionEnd(this.selectionStart);
        }
        this.onChanged(this.text);
    }

    public void setSelectionStart(int cursor) {
        this.selectionStart = class_3532.method_15340((int)cursor, (int)0, (int)this.text.length());
        this.updateFirstCharacterIndex(this.selectionStart);
    }

    public void setCursorToStart(boolean shiftKeyPressed) {
        this.setCursor(0, shiftKeyPressed);
    }

    public void setCursorToEnd(boolean shiftKeyPressed) {
        this.setCursor(this.text.length(), shiftKeyPressed);
    }

    public boolean method_25404(@NotNull class_11908 input) {
        if (this.method_37303() && this.method_25370()) {
            switch (input.comp_4795()) {
                case 259: {
                    this.erase(-1, input.method_74240());
                    return true;
                }
                case 261: {
                    this.erase(1, input.method_74240());
                    return true;
                }
                case 262: {
                    if (input.method_74240()) {
                        this.setCursor(this.getWordSkipPosition(1), input.method_74239());
                    } else {
                        this.moveCursor(1, input.method_74239());
                    }
                    return true;
                }
                case 263: {
                    if (input.method_74240()) {
                        this.setCursor(this.getWordSkipPosition(-1), input.method_74239());
                    } else {
                        this.moveCursor(-1, input.method_74239());
                    }
                    return true;
                }
                case 268: {
                    this.setCursorToStart(input.method_74239());
                    return true;
                }
                case 269: {
                    this.setCursorToEnd(input.method_74239());
                    return true;
                }
            }
            if (input.method_74241()) {
                this.setCursorToEnd(false);
                this.setSelectionEnd(0);
                return true;
            }
            if (input.method_74242()) {
                class_310.method_1551().field_1774.method_1455(this.getSelectedText());
                return true;
            }
            if (input.method_74243()) {
                this.write(class_310.method_1551().field_1774.method_1460());
                return true;
            }
            if (input.method_74244()) {
                class_310.method_1551().field_1774.method_1455(this.getSelectedText());
                this.write("");
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean canConsumeInput() {
        return this.method_37303() && this.method_25370();
    }

    public boolean method_25400(@NotNull class_11905 input) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (input.method_74227()) {
            this.write(input.method_74226());
            return true;
        }
        return false;
    }

    private int getClickPosition(class_11909 click) {
        int i = Math.min(class_3532.method_15357((double)click.comp_4798()) - this.textX, this.getInnerWidth());
        String string = this.text.substring(this.firstCharacterIndex);
        return this.firstCharacterIndex + this.font.method_27523(string, i).length();
    }

    private void onDoubleClick(class_11909 click) {
        int i = this.getClickPosition(click);
        int j = this.getWordSkipPosition(-1, i);
        int k = this.getWordSkipPosition(1, i);
        this.setCursor(j, false);
        this.setCursor(k, true);
    }

    public void method_25348(@NotNull class_11909 click, boolean doubled) {
        if (doubled) {
            this.onDoubleClick(click);
        } else {
            this.setCursor(this.getClickPosition(click), click.method_74239());
        }
    }

    protected void method_25349(@NotNull class_11909 click, double d, double e) {
        this.setCursor(this.getClickPosition(click), true);
    }

    public void method_25354(@NotNull class_1144 soundManager) {
    }

    public void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float deltaTicks) {
        if (this.isVisible()) {
            boolean canSuggestionBeRendered;
            if (this.drawsBackground()) {
                class_2960 identifier = TEXTURES.method_52729(this.method_37303(), this.method_25370());
                graphics.method_52706(class_10799.field_56883, identifier, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
            }
            int i = this.isValid() ? -2039584 : -65536;
            int j = this.selectionStart - this.firstCharacterIndex;
            String string = this.font.method_27523(this.text.substring(this.firstCharacterIndex), this.getInnerWidth());
            boolean bl = j >= 0 && j <= string.length();
            boolean bl2 = this.method_25370() && (class_156.method_658() - this.lastSwitchFocusTime) / 300L % 2L == 0L && bl;
            int k = this.textX;
            int l = class_3532.method_15340((int)(this.selectionEnd - this.firstCharacterIndex), (int)0, (int)string.length());
            boolean textShadow = true;
            if (!string.isEmpty()) {
                String string2 = bl ? string.substring(0, j) : string;
                class_5481 orderedText = this.format(string2);
                graphics.method_51430(this.font, orderedText, k, this.textY, i, textShadow);
                k += this.font.method_30880(orderedText) + 1;
            }
            boolean bl3 = this.selectionStart < this.text.length() || this.text.length() >= this.getMaxLength();
            int m = k;
            if (!bl) {
                m = j > 0 ? this.textX + this.field_22758 : this.textX;
            } else if (bl3) {
                m = k - 1;
                --k;
            }
            if (!string.isEmpty() && bl && j < string.length()) {
                graphics.method_51430(this.font, this.format(string.substring(j)), k, this.textY, i, textShadow);
            }
            boolean bl4 = canSuggestionBeRendered = this.font.method_1727(string + this.suggestion) < this.getInnerWidth();
            if (!this.suggestion.isBlank() && canSuggestionBeRendered) {
                int x = this.method_46426() + this.method_25368() - 4 - this.font.method_1727(this.suggestion);
                graphics.method_51433(this.font, this.suggestion, x, this.textY, -8355712, textShadow);
            }
            if (l != j) {
                int n = this.textX + this.font.method_1727(string.substring(0, l));
                graphics.method_72238(Math.min(m, this.method_46426() + this.field_22758), this.textY - 1, Math.min(n - 1, this.method_46426() + this.field_22758), this.textY + 1 + 9, true);
            }
            if (bl2) {
                if (bl3) {
                    graphics.method_25294(m, this.textY - 1, m + 1, this.textY + 1 + 9, i);
                } else {
                    graphics.method_51433(this.font, HORIZONTAL_CURSOR, m, this.textY, i, textShadow);
                }
            }
            if (this.method_49606()) {
                graphics.method_74037(class_11876.field_62453);
            }
        }
    }

    private class_5481 format(String string) {
        return class_5481.method_30747((String)string, (class_2583)class_2583.field_24360);
    }

    private void updateTextPosition() {
        if (this.font != null) {
            int n;
            String string = this.font.method_27523(this.text.substring(this.firstCharacterIndex), this.getInnerWidth());
            int n2 = this.method_46426();
            if (this.isCentered()) {
                n = (this.method_25368() - this.font.method_1727(string)) / 2;
            } else {
                Objects.requireNonNull(this);
                n = 4;
            }
            this.textX = n2 + n;
            Objects.requireNonNull(this);
            this.textY = this.method_46427() + (this.field_22759 - 8) / 2;
        }
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public int getCursor() {
        return this.selectionStart;
    }

    public boolean drawsBackground() {
        return this.drawsBackground;
    }

    public void method_25365(boolean focused) {
        super.method_25365(focused);
        if (focused) {
            this.lastSwitchFocusTime = class_156.method_658();
        }
    }

    private boolean isCentered() {
        return false;
    }

    public int getInnerWidth() {
        return this.drawsBackground() ? this.field_22758 - 8 : this.field_22758;
    }

    public void setSelectionEnd(int index) {
        this.selectionEnd = class_3532.method_15340((int)index, (int)0, (int)this.text.length());
        this.updateFirstCharacterIndex(this.selectionEnd);
    }

    private void updateFirstCharacterIndex(int cursor) {
        if (this.font != null) {
            this.firstCharacterIndex = Math.min(this.firstCharacterIndex, this.text.length());
            int i = this.getInnerWidth();
            String string = this.font.method_27523(this.text.substring(this.firstCharacterIndex), i);
            int j = string.length() + this.firstCharacterIndex;
            if (cursor == this.firstCharacterIndex) {
                this.firstCharacterIndex -= this.font.method_27524(this.text, i, true).length();
            }
            if (cursor > j) {
                this.firstCharacterIndex += cursor - j;
            } else if (cursor <= this.firstCharacterIndex) {
                this.firstCharacterIndex -= this.firstCharacterIndex - cursor;
            }
            this.firstCharacterIndex = class_3532.method_15340((int)this.firstCharacterIndex, (int)0, (int)this.text.length());
        }
    }

    public boolean isVisible() {
        return this.field_22764;
    }

    public void method_47399(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
    }

    @Override
    public boolean isValid() {
        return this.textPredicate.test(this.text);
    }

    @Generated
    public String getText() {
        return this.text;
    }
}

