/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1923;

public class ChunkPosGenStream {
    public static Iterator<class_1923> getIterator(int genMinX, int genMinZ, int width, int extraRadius) {
        return ChunkPosGenStream.getStream(genMinX, genMinZ, width, extraRadius).iterator();
    }

    public static Stream<class_1923> getStream(int genMinX, int genMinZ, int width, int extraRadius) {
        return StreamSupport.stream(new InclusiveChunkPosIterator(genMinX, genMinZ, width, extraRadius), false);
    }

    private static class InclusiveChunkPosIterator
    extends Spliterators.AbstractSpliterator<class_1923> {
        private final int minX;
        private final int minZ;
        private final int maxX;
        private final int maxZ;
        int x;
        private int z;

        protected InclusiveChunkPosIterator(int genMinX, int genMinZ, int width, int extraRadius) {
            super(InclusiveChunkPosIterator.getCount(width, extraRadius), 64);
            this.minX = genMinX - extraRadius;
            this.minZ = genMinZ - extraRadius;
            this.maxX = genMinX + (width - 1) + extraRadius;
            this.maxZ = genMinZ + (width - 1) + extraRadius;
            this.x = this.minX - 1;
            this.z = this.minZ;
        }

        private static int getCount(int width, int extraRadius) {
            int widthPlusExtra = width + extraRadius * 2;
            return widthPlusExtra * widthPlusExtra;
        }

        @Override
        public boolean tryAdvance(Consumer<? super class_1923> consumer) {
            if (this.x == this.maxX && this.z == this.maxZ) {
                return false;
            }
            if (this.x == this.maxX) {
                this.x = this.minX;
                ++this.z;
            } else {
                ++this.x;
            }
            consumer.accept((class_1923)new class_1923(this.x, this.z));
            return true;
        }
    }
}

