/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog.import_export;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.io.FileHandler;
import journeymap.client.log.ChatLog;
import journeymap.client.task.multi.MapPlayerTask;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.screens.AbstractPopupScreen;
import journeymap.client.ui.component.widgets.ColoredStringWidget;
import journeymap.common.Journeymap;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_7847;
import net.minecraft.class_7852;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

public abstract class ImportPopup
extends AbstractPopupScreen {
    protected final File jmWorldDir;
    protected final List<CheckBox> checkBoxes = new ArrayList<CheckBox>();
    protected final Map<String, Boolean> importFolderSelections = new HashMap<String, Boolean>();
    protected final File sourceFile;

    protected ImportPopup(File sourceFile) {
        super((class_2561)class_2561.method_43471((String)"jm.common.importexport_import_dialog"));
        this.jmWorldDir = FileHandler.getJMWorldDir(class_310.method_1551());
        this.sourceFile = sourceFile;
    }

    public void method_25426() {
        block8: {
            this.layout.method_52738((class_8021)new ColoredStringWidget((class_2561)this.method_25440().method_27661().method_27692(class_124.field_1075).method_27692(class_124.field_1073), this.field_22793), class_7847::method_46467);
            this.layout.method_52735(6);
            this.layout.method_52738((class_8021)new ColoredStringWidget((class_2561)class_2561.method_43471((String)"jm.common.importexport_dialog_import_summary"), this.field_22793), class_7847::method_46467);
            if (this.sourceFile != null && this.sourceFile.exists()) {
                try {
                    Set<String> folders = this.scanForFolders();
                    this.checkBoxes.clear();
                    if (!folders.isEmpty()) {
                        this.layout.method_52740().method_46467();
                        class_8667 horizontalLayout = class_8667.method_52742();
                        horizontalLayout.method_52735(10);
                        class_8667 currentColumn = class_8667.method_52741();
                        currentColumn.method_52735(2);
                        horizontalLayout.method_52736((class_8021)currentColumn);
                        int checkboxesInCurrentColumn = 0;
                        for (String folder : folders) {
                            if (!folder.equals("waypoints")) continue;
                            CheckBox waypointCheckBox = new CheckBox(folder, true, button -> {
                                boolean toggled = ((CheckBox)button).getToggled();
                                this.importFolderSelections.put(folder, toggled);
                            });
                            this.layout.method_52736((class_8021)waypointCheckBox);
                            this.layout.method_52736((class_8021)new class_7852(0, 0));
                            this.checkBoxes.add(waypointCheckBox);
                            this.importFolderSelections.put(folder, true);
                            break;
                        }
                        this.layout.method_52738((class_8021)new ColoredStringWidget((class_2561)class_2561.method_43471((String)"jm.waypoint.dimensions").method_27661().method_27692(class_124.field_1073), this.field_22793), class_7847::method_46467);
                        for (String folder : folders) {
                            if (folder.equals("waypoints")) continue;
                            if (checkboxesInCurrentColumn >= 7) {
                                checkboxesInCurrentColumn = 0;
                                currentColumn = class_8667.method_52741();
                                currentColumn.method_52735(2);
                                horizontalLayout.method_52736((class_8021)currentColumn);
                            }
                            CheckBox checkBox = new CheckBox(folder, true, button -> {
                                boolean toggled = ((CheckBox)button).getToggled();
                                this.importFolderSelections.put(folder, toggled);
                            });
                            currentColumn.method_52736((class_8021)checkBox);
                            this.checkBoxes.add(checkBox);
                            this.importFolderSelections.put(folder, true);
                            ++checkboxesInCurrentColumn;
                        }
                        this.layout.method_52736((class_8021)horizontalLayout);
                        break block8;
                    }
                    this.layout.method_52736((class_8021)new ColoredStringWidget((class_2561)class_2561.method_43471((String)"jm.common.importexport_dialog_no_folders").method_27661().method_27692(class_124.field_1061), this.field_22793));
                }
                catch (Exception e) {
                    this.layout.method_52736((class_8021)new ColoredStringWidget((class_2561)class_2561.method_43470((String)("Error scanning source: " + e.getMessage())).method_27661().method_27692(class_124.field_1061), this.field_22793));
                    Journeymap.getLogger().error("Error scanning source: " + e.getMessage(), (Throwable)e);
                }
            } else {
                this.layout.method_52736((class_8021)new ColoredStringWidget((class_2561)class_2561.method_43471((String)"jm.common.importexport_dialog_no_zip").method_27661().method_27692(class_124.field_1061), this.field_22793));
            }
        }
        class_8667 buttonLayout = class_8667.method_52742();
        buttonLayout.method_52735(10);
        buttonLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"jm.common.importexport_dialog_import_selected"), button -> this.importSelectedFolders()).method_46431());
        buttonLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"jm.common.cancel"), button -> super.method_25419()).method_46431());
        this.layout.method_52736((class_8021)buttonLayout);
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        super.method_48640();
    }

    protected void importSelectedFolders() {
        if (this.sourceFile == null || !this.sourceFile.exists()) {
            ChatLog.announceError(class_2561.method_43471((String)"jm.common.importexport_dialog_no_zip").getString());
            return;
        }
        TreeSet<String> selectedFolders = new TreeSet<String>();
        for (Map.Entry<String, Boolean> entry : this.importFolderSelections.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            selectedFolders.add(entry.getKey());
        }
        if (selectedFolders.isEmpty()) {
            ChatLog.announceError(class_2561.method_43471((String)"jm.common.importexport_dialog_no_folders").getString());
            return;
        }
        try {
            boolean wasMapping = JourneymapClient.getInstance().isMapping();
            if (wasMapping) {
                JourneymapClient.getInstance().stopMapping();
            }
            DataCache.INSTANCE.invalidateChunkMDCache();
            this.importFolders(selectedFolders);
            if (wasMapping) {
                JourneymapClient.getInstance().startMapping();
                MapPlayerTask.forceNearbyRemap();
            }
            ChatLog.announceI18N("jm.common.importexport_dialog_import_success", this.sourceFile.getName());
            Journeymap.getLogger().info("JourneyMap data imported from " + this.sourceFile.getAbsolutePath());
        }
        catch (IOException e) {
            Journeymap.getLogger().error("Error importing JourneyMap data: " + e.getMessage(), (Throwable)e);
            ChatLog.announceError("Error importing JourneyMap data: " + e.getMessage());
        }
        this.method_25419();
    }

    protected abstract Set<String> scanForFolders() throws IOException;

    protected abstract void importFolders(Set<String> var1) throws IOException;
}

