/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.option;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import journeymap.client.Constants;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.model.map.MapType;
import journeymap.common.properties.config.StringField;

public class MapTypeProvider
implements StringField.ValuesProvider {
    private static final Map<MapType.Name, Source> values = new HashMap<MapType.Name, Source>();
    public static Source ANY = MapTypeProvider.create(MapType.Name.any, "jm.common.map_type.auto");
    public static Source DAY = MapTypeProvider.create(MapType.Name.day, MapType.Name.day.getKey());
    public static Source NIGHT = MapTypeProvider.create(MapType.Name.night, MapType.Name.night.getKey());
    public static Source UNDERGROUND = MapTypeProvider.create(MapType.Name.underground, MapType.Name.underground.getKey());
    public static Source BIOME = MapTypeProvider.create(MapType.Name.biome, MapType.Name.biome.getKey());
    public static Source TOPO = MapTypeProvider.create(MapType.Name.topo, MapType.Name.topo.getKey());

    private static Source create(MapType.Name name, String key) {
        Source src = new Source(key, name);
        values.put(name, src);
        return src;
    }

    public static String from(MapType.Name name) {
        return values.get((Object)name).key();
    }

    public static MapType.Name from(String name) {
        return values.values().stream().filter(source -> source.key().equals(name)).map(source -> source.name).findFirst().orElse(MapType.Name.any);
    }

    @Override
    public List<String> getStrings() {
        return values.values().stream().filter(src -> this.isAllowed(src.name)).map(source -> source.key).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }

    boolean isAllowed(MapType.Name name) {
        if (name == MapType.Name.any) {
            return true;
        }
        if (name == MapType.Name.underground) {
            return FeatureManager.getInstance().isAllowed(Feature.MapCaves);
        }
        if (name == MapType.Name.topo) {
            return FeatureManager.getInstance().isAllowed(Feature.MapTopo) && FeatureManager.getInstance().isAllowed(Feature.MapSurface);
        }
        if (name == MapType.Name.day || name == MapType.Name.night) {
            return FeatureManager.getInstance().isAllowed(Feature.MapSurface);
        }
        if (name == MapType.Name.biome) {
            return FeatureManager.getInstance().isAllowed(Feature.MapBiome) && FeatureManager.getInstance().isAllowed(Feature.MapSurface);
        }
        return false;
    }

    @Override
    public String getDefaultString() {
        return ANY.key();
    }

    @Override
    public String getTooltip(String value) {
        for (Source source : values.values()) {
            String tooltip;
            String tooltipKey = null;
            if (source.name.getKey().equals(value)) {
                tooltipKey = source.name.getKey() + ".tooltip";
            } else if (source.key().equals(value)) {
                tooltipKey = source.key() + ".tooltip";
            }
            if (tooltipKey == null || tooltipKey.equals(tooltip = Constants.getString(tooltipKey))) continue;
            return tooltip;
        }
        return null;
    }

    public record Source(String key, MapType.Name name) {
    }
}

