/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.group;

import java.util.Optional;
import java.util.function.Consumer;
import journeymap.client.ui.component.ScrollListLayoutPane;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.waypointmanager.WaypointManager;
import journeymap.client.ui.waypointmanager.group.GroupSlot;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_4587;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8028;

public class GroupPanel<T extends GroupSlot>
extends ScrollListLayoutPane<T> {
    private int lastIndex = -1;
    final WaypointManager manager;

    public GroupPanel(class_310 mc, WaypointManager manager, int x, int y, int width, int height, int slotHeight) {
        super(mc, x, y, width, height, slotHeight);
        this.manager = manager;
    }

    @Override
    public boolean method_25406(class_11909 event) {
        this.method_19355(event.comp_4798(), event.comp_4799());
        return super.method_25406(event);
    }

    @Override
    public void renderSelection(class_332 guiGraphics, Slot<T> entry, int color) {
        int top = entry.method_73382();
        int i = this.method_46426() + (this.field_22758 - entry.method_25368()) / 2;
        int j = this.method_46426() + (this.field_22758 + entry.method_25368()) / 2 - 4;
        guiGraphics.method_25294(i, top - 2, j + 4, top + entry.method_25364() - 2, color);
        guiGraphics.method_25294(i + 1, top - 1, j + 3, top + entry.method_25364() - 3, -16777216);
    }

    @Override
    public void renderBackground(class_332 graphics, class_4587 poseStack, int i, int j, float f) {
    }

    @Override
    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (this.method_25405(event.comp_4798(), event.comp_4799())) {
            this.getRootSlots().forEach(slot -> slot.getLayout().method_48206(widget -> widget.method_25402(event, doubleClick)));
            return super.method_25402(event, doubleClick);
        }
        return false;
    }

    @Override
    public class_8016 method_48205(class_8023 event) {
        Slot focused = null;
        if (this.method_25340() == 0) {
            return null;
        }
        if (event instanceof class_8023.class_8024) {
            class_8016 path;
            class_8023.class_8024 nav = (class_8023.class_8024)event;
            class_8028 direction = nav.comp_1191();
            switch (direction) {
                case field_41826: 
                case field_41827: {
                    focused = (Slot)this.method_48197(event.method_48231());
                    if (focused == null) break;
                    this.manager.updateSelectedGroup(focused);
                    break;
                }
                case field_41829: {
                    this.lastIndex = this.method_25396().indexOf(this.method_25336());
                    break;
                }
                case field_41828: {
                    focused = this.lastIndex > -1 ? this.getSlot(this.lastIndex) : this.getSlot(0);
                    this.manager.updateSelectedGroup(focused);
                }
            }
            do {
                if (focused != null) continue;
                return null;
            } while ((path = focused.method_25396().isEmpty() ? class_8016.method_48193((class_364)focused) : focused.focusPathAtIndex((class_8023)nav, this.lastIndex)) == null);
            return class_8016.method_48192((class_4069)this, (class_8016)path);
        }
        return super.method_48205(event);
    }

    @Override
    public void visitSlots(Consumer<class_339> consumer) {
        this.getRootSlots().forEach(slot -> slot.getLayout().method_48206(consumer));
    }

    @Override
    public void initSlots() {
        this.getRootSlots().forEach(GroupSlot::init);
    }

    @Override
    public void repositionSlots() {
        this.getRootSlots().forEach(GroupSlot::repositionElements);
    }

    public void unselect() {
        this.getRootSlots().forEach(slot -> slot.setSelected(false));
    }

    public void select(String guid) {
        this.getRootSlots().stream().filter(slot -> guid.equals(slot.getGroup().getGuid())).findFirst().ifPresent(t -> {
            t.setSelected(true);
            t.method_25365(true);
            this.method_25313((class_350.class_351)t);
        });
    }

    protected boolean method_25351(class_11910 event) {
        return event.comp_4801() == 0 || event.comp_4801() == 1;
    }

    public void setSelected(String lastSelected) {
        Optional<GroupSlot> group = this.getRootSlots().stream().filter(s -> lastSelected.equals(s.getGroup().getGuid())).findFirst();
        GroupSlot slot = group.orElseGet(() -> (GroupSlot)this.getRootSlots().getFirst());
        slot.setSelected(true);
        slot.method_25365(true);
        this.method_25313((class_350.class_351)slot);
    }
}

